<?php

namespace console\rbac;

use Yii;
use yii\rbac\Rule;
use backend\models\db\Budget;
use backend\models\db\UserParent;

/**
 * Checks if authorID matches user passed via params
 */
class AccessBudgetRule extends Rule {

    public $name = 'accessBudget';

    public function execute($userId, $item, $params) {
        
        $role = Yii::$app->authManager->getRolesByUser($userId);
        $roleName = array_pop($role)->name;
        
        if ($roleName == 'superadmin') {
            
            $budget = Budget::findOne(['id' => $params['budgetId']]);
            
            return is_object($budget);
            
        }
        elseif ($roleName == 'coach') {
            
            $budget = Budget::findOne(['id' => $params['budgetId']]);
            
            if ($budget) {
                
                $parent = UserParent::findOne(['user_id' => $budget->user_id, 'user_parent_id' => $userId]);
                
                return $parent ? true : false;
                        
            }
            else {
                
                return false;
                
            }
            
        }
        else {
            
            $budget = Budget::findOne(['id' => $params['budgetId']]);
            
            if ($budget) {
                
                $mainUserId = Yii::$app->session->get('mainUserId');

                return $mainUserId == $budget->user_id;
                
            }
            else {
                
                return false;
                
            }
        
        }
        
    }

}
