<?php

namespace console\rbac;

use Yii;
use yii\rbac\Rule;
use backend\models\db\UserParent;

/**
 * Checks if authorID matches user passed via params
 */
class AddSubClient extends Rule {

    public $name = 'addSubClient';

    public function execute($userId, $item, $params) {
        
        $role = Yii::$app->authManager->getRolesByUser($userId);
        $roleName = array_pop($role)->name;
        
        if ($roleName == 'superadmin') {
            
            return true;
            
        }
        elseif ($roleName == 'coach') {
            
            $userParent = UserParent::find()
                ->where([
                    'AND',
                    ['user_id' => $params['userId']], 
                    ['user_parent_id' => Yii::$app->user->id]
                ])
                ->one();
            
            return (bool) $userParent;
            
        }
        elseif ($roleName == 'client') {
            
            return true;
        
        }
        else {
            
            return false;
            
        }
        
    }

}
