<?php

namespace console\rbac;

use Yii;
use yii\rbac\Rule;
use backend\models\db\Jar;

/**
 * Checks if authorID matches user passed via params
 */
class EditJarRule extends Rule
{
    public $name = 'editJar';

    public function execute($userId, $item, $params)
    {
        $role = Yii::$app->authManager->getRolesByUser($userId);
        if (array_pop($role)->name == 'superadmin') {
            $jar = Jar::findOne(['id' => $params['jarId']]);
            return is_object($jar);
        }
        else {
            $jar = Jar::findOne(['id' => $params['jarId']]);
            if ($jar) {
                $budget = $jar->getBudget()->one();
                $budgetUser = $budget->getUser()->one();
                $mainUserId = Yii::$app->session->get('mainUserId');
                return $mainUserId == $budgetUser->id;
            }
            else {
                return false;
            }
        }
    }
}
