-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               5.5.46-0ubuntu0.14.04.2 - (Ubuntu)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.3.0.4984
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table gmjs_yii3.accounts
CREATE TABLE IF NOT EXISTS `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `balance` float(10,2) DEFAULT '0.00',
  `account_type_id` int(11) DEFAULT '0',
  `created_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `accounts_budget_id` (`budget_id`),
  KEY `accounts_account_type_id` (`account_type_id`),
  CONSTRAINT `accounts_account_type_id` FOREIGN KEY (`account_type_id`) REFERENCES `account_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `accounts_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.account_balances
CREATE TABLE IF NOT EXISTS `account_balances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `eoms_id` int(11) DEFAULT NULL,
  `balance` float(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_balances_account_id` (`account_id`),
  KEY `eoms_id` (`eoms_id`),
  CONSTRAINT `account_balances_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `account_balances_eoms_id` FOREIGN KEY (`eoms_id`) REFERENCES `eoms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.account_changes
CREATE TABLE IF NOT EXISTS `account_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(1) DEFAULT 'C',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_changes_debt_id` (`account_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `account_changes_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `account_changes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.account_change_meta
CREATE TABLE IF NOT EXISTS `account_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_change_meta_debt_change_id` (`account_change_id`),
  CONSTRAINT `account_change_meta_account_change_id` FOREIGN KEY (`account_change_id`) REFERENCES `account_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.account_eoms_balances
CREATE TABLE IF NOT EXISTS `account_eoms_balances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `eoms_id` int(11) DEFAULT NULL,
  `balance` float(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_balances_account_id` (`account_id`),
  KEY `eoms_id` (`eoms_id`),
  CONSTRAINT `account_eoms_balances_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `account_eoms_balances_eoms_id` FOREIGN KEY (`eoms_id`) REFERENCES `eoms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.account_types
CREATE TABLE IF NOT EXISTS `account_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.appointments
CREATE TABLE IF NOT EXISTS `appointments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `user_id` int(11) NOT NULL COMMENT 'the ID of the coach',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `appointments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.appointment_users
CREATE TABLE IF NOT EXISTS `appointment_users` (
  `appointment_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`appointment_id`,`user_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `appointment_users_appointment_id` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`),
  CONSTRAINT `appointment_users_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.auth_assignment
CREATE TABLE IF NOT EXISTS `auth_assignment` (
  `item_name` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`item_name`,`user_id`),
  CONSTRAINT `auth_assignment_ibfk_1` FOREIGN KEY (`item_name`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.auth_item
CREATE TABLE IF NOT EXISTS `auth_item` (
  `name` varchar(64) NOT NULL,
  `type` int(11) NOT NULL,
  `description` text,
  `rule_name` varchar(64) DEFAULT NULL,
  `data` text,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`name`),
  KEY `rule_name` (`rule_name`),
  KEY `type` (`type`),
  CONSTRAINT `auth_item_ibfk_1` FOREIGN KEY (`rule_name`) REFERENCES `auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.auth_item_child
CREATE TABLE IF NOT EXISTS `auth_item_child` (
  `parent` varchar(64) NOT NULL,
  `child` varchar(64) NOT NULL,
  PRIMARY KEY (`parent`,`child`),
  KEY `child` (`child`),
  CONSTRAINT `auth_item_child_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `auth_item_child_ibfk_2` FOREIGN KEY (`child`) REFERENCES `auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.auth_rule
CREATE TABLE IF NOT EXISTS `auth_rule` (
  `name` varchar(64) NOT NULL,
  `data` text,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.budgets
CREATE TABLE IF NOT EXISTS `budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT 'the user this belongs to, not the coach',
  `name` varchar(200) DEFAULT NULL,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `default_account_id` int(11) DEFAULT NULL,
  `archived` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `budgets_user_id` (`user_id`),
  KEY `default_account_id` (`default_account_id`),
  CONSTRAINT `budgets_default_account_id` FOREIGN KEY (`default_account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `budgets_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.budget_chats
CREATE TABLE IF NOT EXISTS `budget_chats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `text` text,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `budget_chats_budget_id` (`budget_id`),
  KEY `budget_chats_user_id` (`user_id`),
  CONSTRAINT `budget_chats_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `budget_chats_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.bugs
CREATE TABLE IF NOT EXISTS `bugs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `content` text,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(150) DEFAULT NULL,
  `archived` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bugs_user_id` (`user_id`),
  CONSTRAINT `bugs_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.cc_transactions
CREATE TABLE IF NOT EXISTS `cc_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_id` int(11) NOT NULL,
  `debt_id` int(11) NOT NULL,
  `amount` float(10,2) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_id` (`expense_id`),
  KEY `debt_id` (`debt_id`),
  CONSTRAINT `cc_transactions_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cc_transactions_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.conversations
CREATE TABLE IF NOT EXISTS `conversations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT 'main',
  `archived` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.conversations_to_users
CREATE TABLE IF NOT EXISTS `conversations_to_users` (
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`conversation_id`,`user_id`),
  KEY `conversations_to_users_conversation_id` (`conversation_id`),
  KEY `conversations_to_users_user_id` (`user_id`),
  CONSTRAINT `conversations_to_users_conversation_id` FOREIGN KEY (`conversation_id`) REFERENCES `conversations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversations_to_users_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.conversation_messages
CREATE TABLE IF NOT EXISTS `conversation_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'user this message originated from',
  `text` text,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conversation_messages_conversation_id` (`conversation_id`),
  KEY `conversation_messages_user_id` (`user_id`),
  CONSTRAINT `conversation_messages_conversation_id` FOREIGN KEY (`conversation_id`) REFERENCES `conversations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_messages_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.conversation_message_attachments
CREATE TABLE IF NOT EXISTS `conversation_message_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_message_id` int(11) DEFAULT NULL,
  `path` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_message_attachments_conversation_message_id` (`conversation_message_id`),
  CONSTRAINT `conversation_message_attachments_conversation_message_id` FOREIGN KEY (`conversation_message_id`) REFERENCES `conversation_messages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.conversation_message_seen
CREATE TABLE IF NOT EXISTS `conversation_message_seen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_message_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_message_id` (`conversation_message_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `conversation_message_seen_conversation_message_id` FOREIGN KEY (`conversation_message_id`) REFERENCES `conversation_messages` (`id`),
  CONSTRAINT `conversation_message_seen_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.countries
CREATE TABLE IF NOT EXISTS `countries` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.currencies
CREATE TABLE IF NOT EXISTS `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `code` varchar(3) NOT NULL,
  `sign` varchar(3) NOT NULL,
  `position` enum('B','A') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.date_formats
CREATE TABLE IF NOT EXISTS `date_formats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `format` varchar(12) NOT NULL,
  `name` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debts
CREATE TABLE IF NOT EXISTS `debts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) DEFAULT NULL,
  `debt_type_id` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `interest` float(7,3) DEFAULT '0.000',
  `monthly_interest` float(10,2) NOT NULL DEFAULT '0.00',
  `date` date DEFAULT NULL,
  `interest_free_end_date` date DEFAULT NULL,
  `frequency` varchar(20) DEFAULT 'monthly',
  `payment_minimum` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `tax_deductible` tinyint(1) DEFAULT '0',
  `archived` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `debts_debt_type_id` (`debt_type_id`),
  KEY `debts_jar_id` (`budget_id`),
  KEY `debt_account_id` (`account_id`),
  CONSTRAINT `debt_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_type_id` FOREIGN KEY (`debt_type_id`) REFERENCES `debt_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_amounts
CREATE TABLE IF NOT EXISTS `debt_amounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debt_id` int(11) NOT NULL,
  `eoms_id` int(11) DEFAULT NULL,
  `amount` float(10,2) NOT NULL,
  `this_months_amount` float(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_amounts_debt_id` (`debt_id`),
  KEY `eoms_id` (`eoms_id`),
  CONSTRAINT `debt_amounts_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_amounts_eoms_id` FOREIGN KEY (`eoms_id`) REFERENCES `eoms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_changes
CREATE TABLE IF NOT EXISTS `debt_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debt_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(1) DEFAULT 'C',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_changes_debt_id` (`debt_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `debt_changes_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_changes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_change_meta
CREATE TABLE IF NOT EXISTS `debt_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debt_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_change_meta_debt_change_id` (`debt_change_id`),
  CONSTRAINT `debt_change_meta_debt_change_id` FOREIGN KEY (`debt_change_id`) REFERENCES `debt_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_ends
CREATE TABLE IF NOT EXISTS `debt_ends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debt_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `debt_id` (`debt_id`),
  CONSTRAINT `debt_ends_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_payments
CREATE TABLE IF NOT EXISTS `debt_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debt_id` int(11) DEFAULT NULL,
  `debt_payment_type_id` int(11) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `checked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `debt_payments_debt_id` (`debt_id`),
  KEY `debt_payments_account_id` (`account_id`),
  KEY `debt_payment_type_id` (`debt_payment_type_id`),
  CONSTRAINT `debt_payments_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_payments_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `debt_payments_debt_payment_type_id` FOREIGN KEY (`debt_payment_type_id`) REFERENCES `debt_payment_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_payment_types
CREATE TABLE IF NOT EXISTS `debt_payment_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.debt_types
CREATE TABLE IF NOT EXISTS `debt_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.emails
CREATE TABLE IF NOT EXISTS `emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `email_template_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `emails_user_id` (`user_id`),
  KEY `emails_email_template_id` (`email_template_id`),
  CONSTRAINT `emails_email_template_id` FOREIGN KEY (`email_template_id`) REFERENCES `email_templates` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `emails_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.email_templates
CREATE TABLE IF NOT EXISTS `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.eoms
CREATE TABLE IF NOT EXISTS `eoms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` tinyint(2) NOT NULL,
  `year` smallint(4) NOT NULL,
  `submitted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `budget_id` (`budget_id`),
  CONSTRAINT `eoms_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expenses
CREATE TABLE IF NOT EXISTS `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jar_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `frequency` varchar(20) DEFAULT 'one-time',
  `tax_deductible` tinyint(1) DEFAULT '0',
  `generate_transactions` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'for one-time this sets whether something gets paid in parts, for recurring it sets whether transactions are auto-generated or not',
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expenses_account_id` (`account_id`),
  KEY `expenses_jar_id` (`jar_id`),
  CONSTRAINT `expenses_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_jar_id` FOREIGN KEY (`jar_id`) REFERENCES `jars` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expense_changes
CREATE TABLE IF NOT EXISTS `expense_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(1) DEFAULT 'C',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_changes_expense_id` (`expense_id`),
  KEY `expense_changes_user_id` (`user_id`),
  CONSTRAINT `expense_changes_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expense_changes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expense_change_meta
CREATE TABLE IF NOT EXISTS `expense_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_change_meta_expense_change_id` (`expense_change_id`),
  CONSTRAINT `expense_change_meta_expense_change_id` FOREIGN KEY (`expense_change_id`) REFERENCES `expense_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expense_debts
CREATE TABLE IF NOT EXISTS `expense_debts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_id` int(11) NOT NULL,
  `debt_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_id` (`expense_id`),
  KEY `debt_id` (`debt_id`),
  CONSTRAINT `expense_debts_debt_id` FOREIGN KEY (`debt_id`) REFERENCES `debts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expense_debts_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expense_ends
CREATE TABLE IF NOT EXISTS `expense_ends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_id` (`expense_id`),
  CONSTRAINT `expense_ends_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.expense_starts
CREATE TABLE IF NOT EXISTS `expense_starts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `expense_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_starts_expense_id` (`expense_id`),
  CONSTRAINT `expense_starts_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.faq_categories
CREATE TABLE IF NOT EXISTS `faq_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `description` text,
  `order` int(11) NOT NULL,
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.faq_questions
CREATE TABLE IF NOT EXISTS `faq_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `description` text NOT NULL,
  `faq_category_id` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `faq_category_id` (`faq_category_id`),
  CONSTRAINT `fk_faq_questions_category_id` FOREIGN KEY (`faq_category_id`) REFERENCES `faq_categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.incomes
CREATE TABLE IF NOT EXISTS `incomes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `frequency` varchar(20) DEFAULT 'one-time',
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `incomes_account_id` (`account_id`),
  KEY `budget_id` (`budget_id`),
  CONSTRAINT `incomes_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `incomes_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.income_changes
CREATE TABLE IF NOT EXISTS `income_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(1) DEFAULT 'C',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `income_changes_income_id` (`income_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `income_changes_income_id` FOREIGN KEY (`income_id`) REFERENCES `incomes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `income_changes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.income_change_meta
CREATE TABLE IF NOT EXISTS `income_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `income_change_meta_income_change_id` (`income_change_id`),
  CONSTRAINT `income_change_meta_income_change_id` FOREIGN KEY (`income_change_id`) REFERENCES `income_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.income_ends
CREATE TABLE IF NOT EXISTS `income_ends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `income_id` (`income_id`),
  CONSTRAINT `income_ends_income_id` FOREIGN KEY (`income_id`) REFERENCES `incomes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.income_transactions
CREATE TABLE IF NOT EXISTS `income_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_id` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `checked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `income_events_income_id` (`income_id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `income_events_income_id` FOREIGN KEY (`income_id`) REFERENCES `incomes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `income_transactions_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.invoices
CREATE TABLE IF NOT EXISTS `invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `bill_date` date NOT NULL,
  `bill_name` varchar(255) NOT NULL,
  `bill_address_1` varchar(255) NOT NULL,
  `bill_address_2` varchar(255) NOT NULL,
  `bill_address_3` varchar(255) NOT NULL,
  `bill_country` varchar(255) NOT NULL,
  `total` decimal(8,2) NOT NULL DEFAULT '0.00',
  `payment_data` text,
  PRIMARY KEY (`id`),
  KEY `invoices_user_ix` (`user_id`),
  CONSTRAINT `fk_invoices_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.invoice_items
CREATE TABLE IF NOT EXISTS `invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `user_plan_id` int(11) DEFAULT NULL,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `description` varchar(255) NOT NULL,
  `amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_ix` (`invoice_id`),
  KEY `fk_user_plans_user_plan_id` (`user_plan_id`),
  CONSTRAINT `fk_invoice_items_invoice_id` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`),
  CONSTRAINT `fk_user_plans_user_plan_id` FOREIGN KEY (`user_plan_id`) REFERENCES `user_plans` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.jars
CREATE TABLE IF NOT EXISTS `jars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) DEFAULT NULL,
  `jar_type_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(200) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `created_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `jars_budget_id` (`budget_id`),
  KEY `jar_type_id` (`jar_type_id`),
  CONSTRAINT `jars_budget_id` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `jars_jar_type_id` FOREIGN KEY (`jar_type_id`) REFERENCES `jar_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.jar_changes
CREATE TABLE IF NOT EXISTS `jar_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jar_id` int(11) DEFAULT NULL,
  `type` varchar(1) DEFAULT 'C',
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jar_changes_jar_id` (`jar_id`),
  CONSTRAINT `jar_changes_jar_id` FOREIGN KEY (`jar_id`) REFERENCES `jars` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.jar_change_meta
CREATE TABLE IF NOT EXISTS `jar_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jar_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jar_change_meta_jar_change_id` (`jar_change_id`),
  CONSTRAINT `jar_change_meta_jar_change_id` FOREIGN KEY (`jar_change_id`) REFERENCES `jar_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.jar_types
CREATE TABLE IF NOT EXISTS `jar_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.migration
CREATE TABLE IF NOT EXISTS `migration` (
  `version` varchar(180) NOT NULL,
  `apply_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notes
CREATE TABLE IF NOT EXISTS `notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT 'the ID of the coach this note belongs to',
  `user_client_id` int(11) DEFAULT NULL COMMENT 'the user_id of the client this note is about',
  `name` varchar(120) DEFAULT NULL,
  `content` text,
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `time_edited` timestamp NULL DEFAULT NULL,
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `notes_user_id` (`user_id`),
  KEY `client_id` (`user_client_id`),
  CONSTRAINT `notes_user_client_id` FOREIGN KEY (`user_client_id`) REFERENCES `users` (`id`),
  CONSTRAINT `notes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.note_attachments
CREATE TABLE IF NOT EXISTS `note_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `note_id` int(11) DEFAULT NULL,
  `name` text NOT NULL,
  `path` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `note_attachments_note_id` (`note_id`),
  CONSTRAINT `note_attachments_note_id` FOREIGN KEY (`note_id`) REFERENCES `notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `notification_template_name` varchar(30) DEFAULT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notification_template_name` (`notification_template_name`),
  CONSTRAINT `notifications_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notification_categories
CREATE TABLE IF NOT EXISTS `notification_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notification_data
CREATE TABLE IF NOT EXISTS `notification_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) NOT NULL,
  `key` varchar(30) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `notification_data_notification_id` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notification_reminders
CREATE TABLE IF NOT EXISTS `notification_reminders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) NOT NULL,
  `remind_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'temporarily not being used',
  `reminded` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  CONSTRAINT `notification_reminders_notification_id` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.notification_templates
CREATE TABLE IF NOT EXISTS `notification_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text,
  `name` varchar(30) NOT NULL,
  `notification_category_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_category_id` (`notification_category_id`),
  CONSTRAINT `notification_templates_notification_category_id` FOREIGN KEY (`notification_category_id`) REFERENCES `notification_categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.pages
CREATE TABLE IF NOT EXISTS `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `content` text,
  `archived` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.time_formats
CREATE TABLE IF NOT EXISTS `time_formats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `format` varchar(12) NOT NULL,
  `name` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.time_zones
CREATE TABLE IF NOT EXISTS `time_zones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `code` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transactions
CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) DEFAULT NULL,
  `expense_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `checked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `transactions_account_id` (`account_id`),
  KEY `transactions_expense_id` (`expense_id`),
  CONSTRAINT `transactions_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `transactions_expense_id` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transfers
CREATE TABLE IF NOT EXISTS `transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_from_id` int(11) DEFAULT NULL,
  `account_to_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `frequency` varchar(20) DEFAULT 'one-time',
  `amount` float(10,2) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `budget_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfers_account_from_id` (`account_from_id`),
  KEY `transfers_account_to_id` (`account_to_id`),
  CONSTRAINT `transfers_account_from_id` FOREIGN KEY (`account_from_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `transfers_account_to_id` FOREIGN KEY (`account_to_id`) REFERENCES `accounts` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transfer_changes
CREATE TABLE IF NOT EXISTS `transfer_changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(1) DEFAULT 'C',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_changes_transfer_id` (`transfer_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `transfer_changes_transfer_id` FOREIGN KEY (`transfer_id`) REFERENCES `transfers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `transfer_changes_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transfer_change_meta
CREATE TABLE IF NOT EXISTS `transfer_change_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_change_id` int(11) DEFAULT NULL,
  `key` varchar(40) DEFAULT NULL,
  `value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_change_meta_transfer_change_id` (`transfer_change_id`),
  CONSTRAINT `transfer_change_meta_transfer_change_id` FOREIGN KEY (`transfer_change_id`) REFERENCES `transfer_changes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transfer_ends
CREATE TABLE IF NOT EXISTS `transfer_ends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_ends_transfer_id` (`transfer_id`),
  CONSTRAINT `transfer_ends_transfer_id` FOREIGN KEY (`transfer_id`) REFERENCES `transfers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.transfer_events
CREATE TABLE IF NOT EXISTS `transfer_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `checked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `transfer_events_transfer_id` (`transfer_id`),
  CONSTRAINT `transfer_events_transfer_id` FOREIGN KEY (`transfer_id`) REFERENCES `transfers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.updates
CREATE TABLE IF NOT EXISTS `updates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `step` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_role_id` int(11) NOT NULL DEFAULT '3',
  `username` varchar(50) NOT NULL,
  `password` varchar(60) NOT NULL,
  `password_salt` varchar(12) NOT NULL,
  `email` varchar(60) NOT NULL,
  `auth_key` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `archived` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `user_name` (`user_role_id`),
  CONSTRAINT `users_user_role_id` FOREIGN KEY (`user_role_id`) REFERENCES `user_roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_activity
CREATE TABLE IF NOT EXISTS `user_activity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(64) DEFAULT NULL,
  `title` varchar(128) NOT NULL,
  `description` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `data` text NOT NULL,
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_activity_ix` (`user_id`),
  KEY `archived` (`archived`),
  CONSTRAINT `user_activity_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_logins
CREATE TABLE IF NOT EXISTS `user_logins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Time at which the user logged in.',
  `duration` int(11) NOT NULL COMMENT 'seconds',
  PRIMARY KEY (`id`),
  KEY `user_logins_user_id` (`user_id`),
  CONSTRAINT `user_logins_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_meta
CREATE TABLE IF NOT EXISTS `user_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `key` varchar(45) DEFAULT NULL,
  `value` varchar(200) DEFAULT NULL,
  `visible` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id` (`user_id`),
  CONSTRAINT `user_meta_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_parents
CREATE TABLE IF NOT EXISTS `user_parents` (
  `user_id` int(11) NOT NULL,
  `user_parent_id` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`user_parent_id`),
  KEY `user_parents_user_id` (`user_id`),
  KEY `user_parents_user_parent_id` (`user_parent_id`),
  CONSTRAINT `user_parents_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_parents_user_parent_id` FOREIGN KEY (`user_parent_id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_password_reset_requests
CREATE TABLE IF NOT EXISTS `user_password_reset_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `auth_token` varchar(100) DEFAULT NULL,
  `used_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `user_password_reset_requests_user_id` (`user_id`),
  CONSTRAINT `user_password_reset_requests_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_plans
CREATE TABLE IF NOT EXISTS `user_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `user_plan_type_id` int(11) DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `is_cancelled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_trial_id` (`user_id`),
  KEY `user_plans_user_plan_type_id` (`user_plan_type_id`),
  CONSTRAINT `user_plans_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_plans_user_plan_type_id` FOREIGN KEY (`user_plan_type_id`) REFERENCES `user_plan_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_plan_details
CREATE TABLE IF NOT EXISTS `user_plan_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_plan_type_id` int(11) NOT NULL,
  `user_plan_feature_id` int(11) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `archived` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_plan_details_tyep_fk` (`user_plan_type_id`),
  KEY `user_plan_details_feature_fk` (`user_plan_feature_id`),
  KEY `user_plan_details_archived_ix` (`archived`),
  CONSTRAINT `fk_user_plan_details_feature_id` FOREIGN KEY (`user_plan_feature_id`) REFERENCES `user_plan_features` (`id`),
  CONSTRAINT `fk_user_plan_details_type_id` FOREIGN KEY (`user_plan_type_id`) REFERENCES `user_plan_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_plan_features
CREATE TABLE IF NOT EXISTS `user_plan_features` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `order` smallint(6) NOT NULL DEFAULT '1',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_plan_features_archived_ix` (`archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_plan_types
CREATE TABLE IF NOT EXISTS `user_plan_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `cost` float(10,2) DEFAULT NULL,
  `consultation_amount` tinyint(4) DEFAULT NULL,
  `consultation_period` varchar(20) DEFAULT NULL COMMENT 'number of months user_plan_type_consultation_amount applies to',
  `plan_length` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_plan_type_durations
CREATE TABLE IF NOT EXISTS `user_plan_type_durations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_plan_type_id` int(11) DEFAULT NULL,
  `months` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_plan_type_durations_user_plan_type_id` (`user_plan_type_id`),
  CONSTRAINT `user_plan_type_durations_user_plan_type_id` FOREIGN KEY (`user_plan_type_id`) REFERENCES `user_plan_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_registrations
CREATE TABLE IF NOT EXISTS `user_registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `auth_token` varchar(42) DEFAULT NULL,
  `auth_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `user_registrations_user_id` (`user_id`),
  CONSTRAINT `user_registrations_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.


-- Dumping structure for table gmjs_yii3.user_roles
CREATE TABLE IF NOT EXISTS `user_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data exporting was unselected.
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
